<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of JobCard_Controller
 *
 * @author Code sys PC 7
 */
class JobCard_Controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('jobcard');
        $this->load->model('customer');
        $this->load->helper('form');
        $this->load->helper('url');
    }

    function saveJobCard() {
        date_default_timezone_set('UTC');
        $quot_total = $this->input->post("quot_total");
        $quot_id = $this->input->post("txt_quot_id");
        $quot_advance = $this->input->post("jc_advanced_payment");
        $quot_balance = $this->input->post("jc_balance_payment");
        $quot_customer = $this->input->post("txt_quot_customer");
        session_start();
        $user = $_SESSION["user"];
        $userid = $user['id'];
        $date = date('Y-m-d');
        $qt_data = array('date' => $date, 'job_card_total' => $quot_total, 'advanced_amount' => $quot_advance, 'balance_amount' => $quot_balance, 'customer_customer_id' => $quot_customer, 'user_iduser' => $userid);
        $jobcard = $this->jobcard->saveJobCard($qt_data, $quot_id);
        $table_row_count = $this->input->post("txt_table_row_count");
        for ($i = 1; $i < $table_row_count + 1; $i++) {
            $procode = $this->input->post("quot_pr_code" . $i);
            $pr_qty = $this->input->post("quot_pr_qty" . $i);
            $pr_price = $this->input->post("quot_pr_price" . $i);
            $this->saveJobCardDetail($procode, $pr_qty, $pr_price, $jobcard, $quot_customer);
        }
        echo 'Successsfully Saved';
    }

    function saveJobCardDetail($prcode, $prqty, $prprice, $jobcard, $customer) {
        if ($prcode !== NULL) {
            $prod_dt = $this->customer->searchSingleProduct($prcode, $customer);
            foreach ($prod_dt->result() as $rw) {
                $proid = $rw->product_id;
                $job_card_details = array('job_card_idjob_card' => $jobcard, 'customers_product_product_id' => $proid, 'job_card_qty' => $prqty, 'product_amount' => $prprice);
                $this->jobcard->saveJobCardDetails($job_card_details);
            }
        }
    }

    function completeJobCard() {
        $jobcard_id = $this->input->get("id_jc");
        $this->jobcard->jobCardCompleted($jobcard_id);
    }

}
