<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Quotation_Controller
 *
 * @author Code sys PC 7
 */
class Quotation_Controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('quotationm');
        $this->load->model('customer');
        $this->load->helper('form');
        $this->load->helper('url');
    }

    function saveQuotationAndEmail() {
        date_default_timezone_set('UTC');
        $quot_total = $this->input->post("quot_total");
        $quot_discount = $this->input->post("quot_discount");
        $quot_grand_total = $this->input->post("quot_grand_total");
        $quot_customer = $this->customer->searchSingleCustomer($this->input->post("txt_quot_customer"));
        session_start();
        $user = $_SESSION["user"];
        $userid = $user['id'];
        foreach ($quot_customer->result() as $row) {
            $customer = $row->customer_id;
            $date = date('Y-m-d');
            $qt_data = array('date' => $date, 'quotation_total' => $quot_total, 'quotation_discount' => $quot_discount, 'quotation_granTotal' => $quot_grand_total, 'customer_customer_id' => $customer, 'user_iduser' => $userid);
            $quotation = $this->quotationm->saveQuotation($qt_data);
            $table_row_count = $this->input->post("txt_table_row_count");
            for ($i = 1; $i < $table_row_count + 1; $i++) {
                $procode = $this->input->post("quot_pr_code" . $i);
                $pr_qty = $this->input->post("quot_pr_qty" . $i);
                $pr_price = $this->input->post("quot_pr_price" . $i);
                $this->saveQuotationDetails($procode, $pr_qty, $pr_price, $quotation, $customer);
            }
            break;
        }
        redirect(base_url() . "index.php/Ui_controller/view_quotation?quot=" . $quotation);
    }

    function saveQuotationDetails($prcode, $prqty, $prprice, $quot, $customer) {
        $prod_dt = $this->customer->searchSingleProduct($prcode, $customer);
        foreach ($prod_dt->result() as $rw) {
            $proid = $rw->product_id;
            $quot_details = array('quotation_idquotation' => $quot, 'customers_product_product_id' => $proid, 'qty' => $prqty, 'total_amount' => $prprice);
            $this->quotationm->saveQuotationDetails($quot_details);
        }
    }

    function sendQuotation() {
        date_default_timezone_set('UTC');
        $this->quotationm->sendEmail("isurushihan@gmail.com", "Quotation", "<html><body><div style='width: 800px; border: 1px solid black;'>
                <div style='font-family: sans-serif; font-size: 30px; font-weight: bolder; margin-top: 50px; margin-bottom: 30px; border: 3px silver dotted;'>Quotation</div>
                <br>
                                        <div align='left'><label>Customer : </label>Isuru Shehan Bhagya</div>
                        <br>
                        <div align='left'><label>Date : </label>2016-01-14</div>
                        <br>
                                        <table border='1' style='width: 100%; border: 1px solid silver; border-collapse: collapse;'>
                    <thead>
                        <tr>
                            <th>Print Code</th>
                            <th>Quantity</th>
                            <th>Price</th>
                        </tr>
                    </thead>
                    <tbody>
                                                        <tr>
                                    <td>121</td>
                                    <td>100</td>
                                    <td>5000.00</td>
                                </tr>
                                                    </tbody>
                </table>
                <div class='quot_details' align='right' style='width: %;'>
                    <table border='0'>
                        <tbody>
                            <tr>
                                <td class='qt_det_td1'>Total</td>
                                <td>:</td>
                                <td class='qt_det_td2'><input id='txt_total' type='text' name='quot_total' value='5000.00' readonly=''></td>
                            </tr>
                            <tr>
                                <td class='qt_det_td1'>Discount</td>
                                <td>:</td>
                                <td class='qt_det_td2'><input id='txt_discount' type='text' name='quot_discount' value='0.00' readonly=''></td>
                            </tr>
                            <tr>
                                <td class='qt_det_td1'>Grand Total</td>
                                <td>:</td>
                                <td class='qt_det_td2'><input id='txt_grand_total' type='text' name='quot_grand_total' value='5000.00' readonly=''></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div></body><html>", "");
    }

    function saveItemCostDetails() {
        $customer_id = $this->input->post("ic_customer");
        $item_name = $this->input->post("ic_item_name");
        $costed_price = $this->input->post("ic_costed_price");
        $quoted_price = $this->input->post("ic_quoted_price");
        $item_length = $this->input->post("ic_item_length");
        $item_width = $this->input->post("ic_item_width");
        $item_material = $this->input->post("ic_item_material");
        $item_qty = $this->input->post("ic_item_qty");
        $r_item_qty = $this->input->post("ic_item_rqty");
        $outs = $this->input->post("ic_item_outs");
        $itemcostdetails = array('customer_id' => $customer_id, 'item_name' => $item_name, 'costed_price' => $costed_price, 'quoted_price' => $quoted_price, 'item_length' =>
            $item_length, 'item_width' => $item_width, 'item_material' => $item_material, 'item_qty' => $item_qty, 'r_item_qty' => $r_item_qty, 'outs' => $outs);
        $this->quotationm->saveItemCost($itemcostdetails);
        redirect(base_url()."index.php/Ui_controller/quotations");
    }

}
