<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Customer
 *
 * @author Code sys PC 7
 */
class Customer extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function saveCustomer($array_insert_customer_data) {
        $this->db->insert("customer", $array_insert_customer_data);
    }

    public function saveCustomerProduct($array_insert_customer_product_data) {
        $this->db->insert("customers_product", $array_insert_customer_product_data);
    }

    public function getAllCustomers() {
        $this->db->select('*');
        $allCustomers = $this->db->get_where('customer');
        return $allCustomers;
    }

    public function getAllCustomerProduct($customer_id) {
        $this->db->select('*');
        $allCust_products = $this->db->get_where('customer', array('customer_customer_id' => $customer_id));
        return $allCust_products;
    }

    public function deleteCustomer($csutomerid) {
        $this->db->where('customer_id', $csutomerid);
        $this->db->update("customer", array('delete_status' => '0'));
    }

    public function updateCustomerDetails($customer_id, $array_details) {
        $this->db->where('customer_id', $customer_id);
        $this->db->update("customer", $array_details);
    }

    public function deleteCustomerProduct($printid) {
        $this->db->where('product_id', $printid);
        $this->db->update("customers_product", array('delete_status' => '0'));
    }

    public function updateCustomerProductDetails($printid, $array_details) {
        $this->db->where('product_id', $printid);
        $this->db->update("customers_product", $array_details);
    }

    public function searchSingleCustomer($customer_name) {
        $this->db->select('customer_id');
        $customer = $this->db->get_where('customer', array('customer_name' => $customer_name));
        if ($customer->num_rows() == 0) {// should be only ONE matching row!!
            return FALSE;
        } else {
            return $customer;
        }
    }

    public function searchSingleProduct($customer_procode, $customer_id) {
        $this->db->select('product_id');
        $product = $this->db->get_where('customers_product', array('customer_customer_id' => $customer_id, 'customers_product_code' => $customer_procode));
        if ($product->num_rows() == 0) {// should be only ONE matching row!!
            return FALSE;
        } else {
            return $product;
        }
    }

}
