<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$this->load->helper('url');
$this->load->helper('form');
?>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Costing Sheet</title>
        <style type="text/css">
            .ldTable{
                border-collapse: collapse;
            }
            .rdFont{
                color: red;
                font-weight: bold;
            }
            .bdFont{
                font-weight: bold;
            }
            .colorRow{
                background-color: #99ff99;
            }
            input{
                text-align: right;
            }
        </style>
        <script type="text/javascript" src="<?php echo base_url(); ?>/assests/js/jquery-1.6.4.min.js"></script>
        <script type="text/javascript">

            $(document).ready(function() {
                $("input:text").focus(function() {
                    $(this).select();
                });
            });

            function setMaterialDetails(cost) {
                $("#material_rate").val(cost);
                $("#material_rate").focus();
            }
        </script>

        <script type="text/javascript">
            var matTotal = 0;
            var matqty = 0;
            var itemQty = 0;
            var quotitemCostin = 0;
            var outs = 0;
            var diga = 0;
            var palala = 0;
            var area = 0;


            function handleDate(e) {
                if (e.keyCode === 13) {
                    $("#customer").focus();
                }
            }

            function handleCustomer(e) {
                if (e.keyCode === 13) {
                    $("#po").focus();
                }
            }

            function handlePO(e) {
                if (e.keyCode === 13) {
                    $("#outs").focus();
                }
            }

            function handleOuts(e) {
                if (e.keyCode === 13) {
                    $("#pr_length").focus();
                }
            }

            function handleLength(e) {
                if (e.keyCode === 13) {
                    $("#pr_width").focus();
                }
            }

            function handleWidth(e) {
                if (e.keyCode === 13) {
                    $("#item_name").focus();
                }
            }

            function handleItemName(e) {
                if (e.keyCode === 13) {
                    $("#item_material").focus();
                }
            }

            function proceedCalculation() {
                calculateArea();
                materialTotal();
                interestOnBoxBoard();
                windowCost();
                LaminationCost();
                labourCost();
                gumCost();
                costPlatesAndCredting();
                inkCostCalculation();
//                calculateCommission();
                calculateTotalCost();
                setFormValues();
            }

            function calculateArea() {
                diga = parseFloat($("#pr_length").val());
                palala = parseFloat($("#pr_width").val());
                area = diga * palala;
            }

            function materialTotal() {
                var rate = parseFloat($("#material_rate").val());
                matqty = parseFloat($("#material_qty").val());
                matTotal = rate * matqty;
                itemQty = outs * matqty;
                outs = parseFloat($("#outs").val())
                $("#material_total_value").val(matTotal.toFixed(2));
            }



            function interestOnBoxBoard() {
                if ($("#customer").val() == "select") {
                    alert("Please select a customer.");
                } else {
                    var cperiod = parseFloat($("#credit_period").val());
                    var interstOnBoxBoardValue = (((matTotal * 0.18) / 365) * cperiod).toFixed(2);
                    $("#interestBoxboard").val(interstOnBoxBoardValue);
                }
//                Math.round(num * 100) / 100
            }

            function windowCost() {
//                itemQty = parseFloat($("#item_qty").val());
                var costpwindow = parseFloat($("#costpWindow").val());
                var windowscost = costpwindow * itemQty;
                $("#windowcost").val(windowscost.toFixed(2));
            }

            function LaminationCost() {
                var lami_rate = parseFloat($("#laminationRate").val());
                var lami_Cost = lami_rate * area * itemQty;
                $("#laminationCost").val(lami_Cost.toFixed(2));
            }

            function labourCost() {
                var labourcosting = (itemQty / 1000) * 35;
                $("#labourcostin").val(labourcosting.toFixed(2));

            }

            function gumCost() {
                var gumCosting = itemQty * 2;
                $("#gumcostin").val(gumCosting.toFixed(2));
            }
            function costPlatesAndCredting() {
                var platerate = parseFloat($("#pmPlatesrate").val());
                var plateqty = parseFloat($("#pmPlatesqty").val());
                var plateTot = platerate * plateqty;
                $("#pmPlatesvalue").val(plateTot.toFixed(2));
                var crestingrate = parseFloat($("#pmCrestingrate").val());
                var crestinqty = parseFloat($("#pmCrestingqty").val());
                var crestingTot = crestingrate * crestinqty;
                $("#pmCrestingvalue").val(crestingTot.toFixed(2));
            }

            function inkCostCalculation(i) {
                if ($("#iqty" + i).val() != "") {
                    var qty = parseFloat($("#iqty" + i).val());
                    var rate = parseFloat($("#irate" + i).val());
                    var total = qty * rate;
                    $("#ivalue" + i).val(total.toFixed(2));
                } else {
                    $("#ivalue" + i).val(0..toFixed(2));
                }
            }
//            function calculateCommission() {
//                var comis = parseFloat($("#commision_p_item").val());
//                totComis = comis * itemQty;
//                $("#totalCommission").val(totComis);
//            }
            function calculateTotalCost() {
                var totalQuotsCost = 0;
                var table = document.getElementById("ldTableBody");
                var table_row_count = table.rows.length;
                for (var row = 0; row < table_row_count - 2; row++) {
                    if (table.rows[row].cells[4].hasChildNodes()) {
                        var chValue = parseFloat(table.rows[row].cells[4].children[0].value);
                        totalQuotsCost = totalQuotsCost + chValue;
                        document.getElementById("quotCalTotal").value = totalQuotsCost.toFixed(2);
                    }
                }
                quotitemCostin = totalQuotsCost;
                calculateQuotCostPerItem();
            }

            function calculateQuotCostPerItem() {
                var unitQuot_price = quotitemCostin / itemQty;
                $("#quot_unitprice").val(unitQuot_price.toFixed(2));
            }

            function realQuotCost() {
                var itemrate = parseFloat($("#item_rate").val());
                var ritemQty = parseFloat($("#item_qty").val());
//                var rTotalCost = itemQty * itemrate;
                var rTotalCost = ritemQty * itemrate;
                setFormValues();
                $("#item_total_value").val(rTotalCost.toFixed(2));
                $("#totalR").val(rTotalCost.toFixed(2));
                $("#realTotalValue").val(rTotalCost.toFixed(2));

                var profloss = rTotalCost - quotitemCostin;
                $("#profitORloss").val(profloss.toFixed(2));

                var gpmargin = (profloss / rTotalCost) * 100
                $("#gpmargin").val(gpmargin.toFixed(2));
            }

            function calculateRealCost() {
                realQuotCost();
            }

            function setCreditPeriod(cperiod) {
                $("#credit_period").val(cperiod);
            }

            function setLaminationRate(rate) {
                $("#laminationRate").val(rate);
                $("#laminationRate").focus();
            }

            function handleMaterialRate(e) {
                if (e.keyCode === 13) {
                    $("#material_qty").focus();
                }
                return false;
            }

            function handleMaterialQty(e) {
                if (e.keyCode === 13) {
                    materialTotal();
                    interestOnBoxBoard();
                    $("#material_total_value").focus();
                }
                return false;
            }

            function handleMaterialTotal(e) {
                if (e.keyCode === 13) {
                    interestOnBoxBoard();
                    $("#tf1").focus();
                    proceedCalculation();
                }
                return false;
            }

            function handleTf1(e) {
                if (e.keyCode === 13) {
                    interestOnBoxBoard();
                    $("#tf2").focus();
                    proceedCalculation();
                }
            }

            function handleTf2(e) {
                if (e.keyCode === 13) {
                    interestOnBoxBoard();
                    $("#interestBoxboard").focus();
                    proceedCalculation();
                }
            }

            function handleINtrBoxBoard(e) {
                if (e.keyCode === 13) {
                    $("#irate1").focus();
                    proceedCalculation();
                }
                return false;
            }

            function handleInk1Rate(e, count) {
                if (e.keyCode === 13) {
                    $("#iqty" + count).focus();
                }
                return false;
            }

            function handleInkQty(e, count) {
                if (e.keyCode === 13) {
                    inkCostCalculation(count)
                    $("#ivalue" + count).focus();
                    proceedCalculation();
                }
                return false;
            }

            function handleInkTotal(e, count) {
                if (e.keyCode === 13) {
                    count = count + 1;
                    if (count <= 7) {
                        $("#irate" + count).focus();
                    } else {
                        $("#positives").focus();
                    }
                    proceedCalculation();
                }
                return false;
            }

            function handlePositives(e) {
                if (e.keyCode === 13) {
                    $("#cutters").focus();
                    proceedCalculation();
                }
                return false;
            }

            function handleCutters(e) {
                if (e.keyCode === 13) {
                    $("#uv_varnish_rate").focus();
                    proceedCalculation();
                }
                return false;
            }

            function handleUVvarnishRate(e) {
                if (e.keyCode === 13) {
                    $("#uvvqty").focus();
                }
            }

            function handleUVvarnishQty(e) {
                if (e.keyCode === 13) {
                    $("#uv_varnish_value").focus();
                }
            }
            function handleUVvarnishValue(e) {
                if (e.keyCode === 13) {
                    $("#sp_uv_varnish_rate").focus();
                    proceedCalculation();
                }
            }
            function handleSpotUVvarnishRate(e) {
                if (e.keyCode === 13) {
                    $("#sp_uvvqty").focus();
                }
            }
            function handleSpotUVvarnishQty(e) {
                if (e.keyCode === 13) {
                    $("#sp_uv_varnish_value").focus();
                }
            }
            function handleSpotUVvarnishValue(e) {
                if (e.keyCode === 13) {
                    $("#emblose_value").focus();
                    proceedCalculation();
                }
            }
            function handleEmbossingBlock(e) {
                if (e.keyCode === 13) {
                    $("#foling_block").focus();
                    proceedCalculation();
                }
            }

            function handleFoilingBlock(e) {
                if (e.keyCode === 13) {
                    $("#foil_charges_rate").focus();
                    proceedCalculation();
                }
            }

            function handleFoilingChargesRate(e) {
                if (e.keyCode === 13) {
                    $("#foil_c_qty").focus();
                }
            }

            function handleFoilingChargesQty(e) {
                if (e.keyCode === 13) {
                    $("#foiling_charge_value").focus();
                }
            }

            function handleFoilingChargesTotal(e) {
                if (e.keyCode === 13) {
                    $("#other_rate").focus();
                    proceedCalculation();
                }
            }

            function handleOtherChargesRate(e) {
                if (e.keyCode === 13) {
                    $("#othqty").focus();
                }
            }

            function handleOtherChargesQty(e) {
                if (e.keyCode === 13) {
                    $("#other_value").focus();
                }
            }
            function handleOtherChargesTotal(e) {
                if (e.keyCode === 13) {
                    $("#costpWindow").focus();
                    proceedCalculation();
                }
            }

            function handleCostpWindow(e) {
                if (e.keyCode === 13) {
                    $("#windowcost").focus();
                    proceedCalculation();
                }
            }

            function handleWindow(e) {
                if (e.keyCode === 13) {
                    $("#embossing").focus();
                    proceedCalculation();
                }
            }

            function handleEmbossing(e) {
                if (e.keyCode === 13) {
                    $("#lamination_types").focus();
                    proceedCalculation();
                }
            }

            function handleLaminationType(e) {
                if (e.keyCode === 13) {
                    $("#laminationCost").focus();
                    proceedCalculation();
                }
            }

            function handleLaminationValue(e) {
                if (e.keyCode === 13) {
                    $("#pmPlatesrate").focus();
                    proceedCalculation();
                }
            }

            function handlePlatesRate(e) {
                if (e.keyCode === 13) {
                    $("#pmPlatesqty").focus();
                }
            }

            function handlePlatesQty(e) {
                if (e.keyCode === 13) {
                    $("#pmPlatesvalue").focus();
                    proceedCalculation();
                }
            }
            function handlePlatesValue(e) {
                if (e.keyCode === 13) {
                    $("#pmCrestingrate").focus();
                    proceedCalculation();
                }
            }
            function handleCresingRate(e) {
                if (e.keyCode === 13) {
                    $("#pmCrestingqty").focus();
                }
            }
            function handleCresingQty(e) {
                if (e.keyCode === 13) {
                    $("#pmCrestingvalue").focus();
                    proceedCalculation();
                }
            }
            function handleCresingValue(e) {
                if (e.keyCode === 13) {
                    $("#labourcostin").focus();
                    proceedCalculation();
                }
            }
            function handleContractWorkLabour(e) {
                if (e.keyCode === 13) {
                    $("#commision").focus();
                    proceedCalculation();
                }
            }
            function handleCommission(e) {
                if (e.keyCode === 13) {
                    $("#printing_charges").focus();
                    proceedCalculation();
                }
            }
            function handlePrintingCharges(e) {
                if (e.keyCode === 13) {
                    $("#gumcostin").focus();
                    proceedCalculation();
                }
            }
            function handleGum(e) {
                if (e.keyCode === 13) {
                    $("#packing_materials").focus();
                    proceedCalculation();
                }
            }
            function handlePackagingMaterials(e) {
                if (e.keyCode === 13) {
                    $("#diecutting_charges").focus();
                    proceedCalculation();
                }
            }
            function handleDieCuttingCharges(e) {
                if (e.keyCode === 13) {
                    $("#gulition_charges").focus();
                    proceedCalculation();
                }
            }
            function handleGulitionCharges(e) {
                if (e.keyCode === 13) {
                    $("#totalCommission").focus();
                    proceedCalculation();
                }
            }
            function handleComis(e) {
                if (e.keyCode === 13) {
                    $("#transport").focus();
                    proceedCalculation();
                }
            }
            function handleTransport(e) {
                if (e.keyCode === 13) {
                    $("#quotCalTotal").focus();
                    proceedCalculation();
                }
            }
            
            function setFormValues() {
                $("#ic_customer").val($("#customer").val());
                $("#ic_item_name").val($("#item_name").val());
                $("#ic_costed_price").val($("#quot_unitprice").val());
                $("#ic_quoted_price").val($("#item_rate").val());
                $("#ic_item_length").val($("#pr_length").val());
                $("#ic_item_width").val($("#pr_width").val());
                $("#ic_item_material").val($("#item_material").val());
                $("#ic_item_qty").val(itemQty);
                $("#ic_item_rqty").val($("#item_qty").val());
                $("#ic_item_outs").val($("#outs").val());
            }
        </script>
    </head>
    <body>
    <center>
        <div>
            <div style="margin: 20px;"><h1>Costing Sheet</h1></div>
            <table border="0" class="ldTable" cellpadding="5" >
                <tr>
                    <td>Date  :</td>
                    <td><input type="date" name="date" onkeypress="handleDate(event)"/></td>
                    <td style="width: 100px;"></td>
                    <td>Customer  :</td>
                    <td>
                        <select id="customer" name="customer" onchange="setCreditPeriod(this.options[this.selectedIndex].getAttribute('c_period'))" onkeypress="handleCustomer(event)">
                            <option value="select">--Select--</option>
                            <?php
                            foreach ($customers->result() as $cust) {
                                ?>
                                <option c_period="<?php echo $cust->credit_period; ?>" value="<?php echo $cust->customer_id; ?>"><?php echo $cust->customer_name; ?></option>
                                <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td>P/O  :</td>
                    <td><input type="text" id="po" name="po" value=""  onkeypress="handlePO(event)"/></td>
                    <td></td>
                    <td>Out  :</td>
                    <td><input type="text" id="outs" name="outs" value=""  onkeypress="handleOuts(event)"/></td>
                </tr>
                <tr>
                    <td>Size</td>
                    <td><input type="text" name="pr_length" id="pr_length" placeholder="Length" value=""  onkeypress="handleLength(event)"/> X <input type="text" name="pr_width" id="pr_width" placeholder="Width" value=""  onkeypress="handleWidth(event)"/></td>
                    <td></td>
                    <td>Customer Credit Period  :  </td>
                    <td><input type="text" readonly="" id="credit_period" name="credit_period" value="" /></td>
                </tr>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>Item  :  </td>
                    <td><input type="text" id="item_name" name="item_name" value=""  onkeypress="handleItemName(event)" /></td>
                </tr>
            </table>
            <table style="border-spacing: 10px;">
                <tr>
                    <td>
                        <table cellpadding="5" border="1" class="ldTable">
                            <tr class="colorRow">
                                <th>Materials</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                            <tr>
                                <th>Box Board</th>
                                <th>Rate</th>
                                <th>Qty</th>
                                <th></th>
                                <th>Value</th>
                            </tr>
                            <tbody id="ldTableBody">
                                <tr>
                                    <!--<select id="item_material" name="item_material" onchange="alert(this.options[this.selectedIndex].getAttribute('isu'))">-->
                                    <td><select id="item_material" name="item_material" onchange="setMaterialDetails(this.options[this.selectedIndex].getAttribute('isu'))">
                                            <option value="select">Select</option>
                                            <?php
                                            foreach ($materials->result() as $matr) {
                                                ?>
                                                <option isu="<?php echo sprintf('%.2f', $matr->material_price); ?>" value="<?php echo $matr->idprint_materials; ?>"><?php echo $matr->material_name; ?></option>
                                                <?php
                                            }
                                            ?>
                                        </select></td>
                                    <td><input type="text" id="material_rate" name="material_rate" value="" onkeypress="handleMaterialRate(event)" /></td>
                                    <td><input type="text" id="material_qty" name="material_qty" value="" onkeypress="handleMaterialQty(event)" /></td>
                                    <td></td>
                                    <td><input type="text" id="material_total_value" name="material_total_value" value="0.00" onkeypress="handleMaterialTotal(event)"/></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="tf1" name="tf1" value="0.00" onkeypress="handleTf1(event)" /></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="tf2" name="tf2" value="0.00" onkeypress="handleTf2(event)" /></td>
                                </tr>
                                <tr>
                                    <td>INTEREST ON BOX BOARD</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="interestBoxboard" name="interestBoxboard" value="0.00" onkeypress="handleINtrBoxBoard(event)" /></td>
                                </tr>
                                <tr class="colorRow">
                                    <td class="bdFont">INK :</td>
                                    <td>7</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Cyan</td>
                                    <td><input type="text" id="irate1" name="irate1" value="1200.00" onkeypress="handleInk1Rate(event, 1)" /></td>
                                    <td><input type="text" id="iqty1" name="iqty1" value="0" onkeypress="handleInkQty(event, 1)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue1" name="ivalue1" value="0.00" onkeypress="handleInkTotal(event, 1)"/></td>
                                </tr>
                                <tr>
                                    <td>Magenta</td>
                                    <td><input type="text" id="irate2" name="irate2" value="1200.00" onkeypress="handleInk1Rate(event, 2)" /></td>
                                    <td><input type="text" id="iqty2" name="iqty2" value="0" onkeypress="handleInkQty(event, 2)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue2" name="ivalue2" value="0.00" onkeypress="handleInkTotal(event, 2)"/></td>
                                </tr>
                                <tr>
                                    <td>Yellow</td>
                                    <td><input type="text" id="irate3" name="irate3" value="1200.00" onkeypress="handleInk1Rate(event, 3)" /></td>
                                    <td><input type="text" id="iqty3" name="iqty3" value="0" onkeypress="handleInkQty(event, 3)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue3" name="ivalue3" value="0.00" onkeypress="handleInkTotal(event, 3)"/></td>
                                </tr>
                                <tr>
                                    <td>Black</td>
                                    <td><input type="text" id="irate4" name="irate4" value="1200.00" onkeypress="handleInk1Rate(event, 4)" /></td>
                                    <td><input type="text" id="iqty4" name="iqty4" value="0" onkeypress="handleInkQty(event, 4)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue4" name="ivalue4" value="0.00" onkeypress="handleInkTotal(event, 4)"/></td>
                                </tr>
                                <tr>
                                    <td>Varnish</td>
                                    <td><input type="text" id="irate5" name="irate5" value="1200.00" onkeypress="handleInk1Rate(event, 5)" /></td>
                                    <td><input type="text" id="iqty5" name="iqty5" value="0" onkeypress="handleInkQty(event, 5)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue5" name="ivalue5" value="0.00" onkeypress="handleInkTotal(event, 5)"/></td>
                                </tr>
                                <tr>
                                    <td>SP 01</td>
                                    <td><input type="text" id="irate6" name="irate6" value="2000.00" onkeypress="handleInk1Rate(event, 6)" /></td>
                                    <td><input type="text" id="iqty6" name="iqty6" value="0" onkeypress="handleInkQty(event, 6)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue6" name="ivalue6" value="0.00" onkeypress="handleInkTotal(event, 6)"/></td>
                                </tr>
                                <tr>
                                    <td>SP 02</td>
                                    <td><input type="text" id="irate7" name="irate7" value="0.00" onkeypress="handleInk1Rate(event, 7)" /></td>
                                    <td><input type="text" id="iqty7" name="iqty7" value="0" onkeypress="handleInkQty(event, 7)"/></td>
                                    <td></td>
                                    <td><input type="text" id="ivalue7" name="ivalue7" value="0.00" onkeypress="handleInkTotal(event, 7)"/></td>
                                </tr>
                                <tr class="colorRow">
                                    <td class="bdFont">OUT SIDE SERVICES :</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>POSITIVES</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="positives" name="positives" value="0.00" onkeypress="handlePositives(event)" /></td>
                                </tr>
                                <tr>
                                    <td>CUTTERS</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="cutters" name="cutters" value="0.00" onkeypress="handleCutters(event)"/></td>
                                </tr>
                                <tr>
                                    <td>UV VARNISH</td>
                                    <td><input type="text" id="uv_varnish_rate" name="uv_varnish_rate" value="0.00" onkeypress="handleUVvarnishRate(event)"/></td>
                                    <td><input type="text" id="uvvqty" name="uvvqty" value="0" onkeypress="handleUVvarnishQty(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="uv_varnish_value" name="uv_varnish_value" value="0.00" onkeypress="handleUVvarnishValue(event)"/></td>
                                </tr>
                                <tr>
                                    <td>SPOT UV VARNISH</td>
                                    <td><input type="text" id="sp_uv_varnish_rate" name="sp_uv_varnish_rate" value="0.00" onkeypress="handleSpotUVvarnishRate(event)"/></td>
                                    <td><input type="text" id="sp_uvvqty" name="sp_uvvqty" value="0" onkeypress="handleSpotUVvarnishQty(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="sp_uv_varnish_value" name="sp_uv_varnish_value" value="0.00" onkeypress="handleSpotUVvarnishValue(event)"/></td>
                                </tr>
                                <tr>
                                    <td>EMBOSSING BLOCK</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="emblose_value" name="emblose_value" value="0.00" onkeypress="handleEmbossingBlock(event)"/></td>
                                </tr>
                                <tr>
                                    <td>FOILING BLOCK</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="foling_block" name="foling_block" value="0.00" onkeypress="handleFoilingBlock(event)"/></td>
                                </tr>
                                <tr>
                                    <td>FOILING CHARGES</td>
                                    <td><input type="text" id="foil_charges_rate" name="foil_charges_rate" value="0.00" onkeypress="handleFoilingChargesRate(event)"/></td>
                                    <td><input type="text" id="foil_c_qty" name="foil_c_qty" value="0" onkeypress="handleFoilingChargesQty(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="foiling_charge_value" name="foiling_charge_value" value="0.00" onkeypress="handleFoilingChargesTotal(event)"/></td>
                                </tr>
                                <tr>
                                    <td>OTHER</td>
                                    <td><input type="text" id="other_rate" name="other_rate" value="0.00" onkeypress="handleOtherChargesRate(event)"/></td>
                                    <td><input type="text" id="othqty" name="othqty" value="0" onkeypress="handleOtherChargesQty(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="other_value" name="other_value" value="0.00" onkeypress="handleOtherChargesTotal(event)"/></td>
                                </tr>
                                <tr>
                                    <td class="rdFont">WINDOW</td>
                                    <td></td>
                                    <td><input type="text" id="costpWindow" name="costpWindow" value="0.00" onkeypress="handleCostpWindow(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="windowcost" name="windowcost" value="0.00" onkeypress="handleWindow(event)"/></td>
                                </tr>
                                <tr>
                                    <td>EMBOSSING</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="embossing" name="embossing" value="0.00" onkeypress="handleEmbossing(event)"/></td>
                                </tr>
                                <tr>
                                    <td>LAMINATION</td>
                                    <td><select id="lamination_types" name="lamination_types" onchange="setLaminationRate(this.value)">
                                            <option value="">--Select--</option>
                                            <option value="0.0095">Gloss</option>
                                            <option value="0.019">Matt</option>
                                            <option value="0.0285">Bold</option>
                                            <option value="0.0285">Window</option>
                                        </select></td>
                                    <td><input type="text" id="laminationRate" name="laminationRate" value="0.00" onkeypress="handleLaminationType(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="laminationCost" name="laminationCost" value="0.00" onkeypress="handleLaminationValue(event)"/></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr class="colorRow">
                                    <td class="bdFont">PROCESS MATERIALS :</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td class="bdFont">Plates</td>
                                    <td><input type="text" id="pmPlatesrate" name="pmPlatesrate" value="1000.00" onkeypress="handlePlatesRate(event)"/></td>
                                    <td><input type="text" id="pmPlatesqty" name="pmPlatesqty" value="0" onkeypress="handlePlatesQty(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="pmPlatesvalue" name="pmPlatesvalue" value="0.00" onkeypress="handlePlatesValue(event)"/></td>
                                </tr>
                                <tr>
                                    <td class="bdFont">Cresing</td>
                                    <td><input type="text" id="pmCrestingrate" name="pmCrestingrate" value="200.00" onkeypress="handleCresingRate(event)"/></td>
                                    <td><input type="text" id="pmCrestingqty" name="pmCrestingqty" value="0" onkeypress="handleCresingQty(event)"/></td>
                                    <td></td>
                                    <td><input type="text" id="pmCrestingvalue" name="pmCrestingvalue" value="0.00" onkeypress="handleCresingValue(event)"/></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr class="colorRow">
                                    <td class="bdFont">OTHER EXPENSES :</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>CONTRACT WORK/LABOUR</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="labourcostin" name="labourcostin" value="0.00" onkeypress="handleContractWorkLabour(event)"/></td>
                                <tr>
                                    <td>COMMISSION</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="commision" name="commision" value="0.00" onkeypress="handleCommission(event)"/></td>
                                </tr>
                                <tr>
                                    <td class="rdFont">PRINTING CHARGES </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="printing_charges" name="printing_charges" value="0.00" onkeypress="handlePrintingCharges(event)"/></td>
                                </tr>
                                <tr>
                                    <td>GUM</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="gumcostin" name="gumcostin" value="0.00" onkeypress="handleGum(event)"/></td>
                                </tr>
                                <tr>
                                    <td>PACKING MATERIAL</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="packing_materials" name="packing_materials" value="0.00" onkeypress="handlePackagingMaterials(event)"/></td>
                                </tr>
                                <tr>
                                    <td class="rdFont">DIE CUTTING CHARGES</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="diecutting_charges" name="diecutting_charges" value="0.00" onkeypress="handleDieCuttingCharges(event)"/></td>
                                </tr>
                                <tr>
                                    <td class="rdFont">GULIITION CHARGES</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="gulition_charges" name="gulition_charges" value="0.00" onkeypress="handleGulitionCharges(event)"/></td>
                                </tr>
                                <tr>
                                    <td class="rdFont">COMMISION</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="totalCommission" name="totalCommission" value="0.00" onkeypress="handleComis(event)"/></td>
                                </tr>
                                <tr>
                                    <td>TRANSPORT</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input type="text" id="transport" name="transport" value="0.00" onkeypress="handleTransport(event)"/></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td class="bdFont">TOTAL COST</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><input readonly="" style="height: 40px;" type="text" id="quotCalTotal" name="quotCalTotal" value="0.00" /></td>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td class="rdFont">Quoted Unit Price  : </td>
                                    <td><input type="text" style="color: red;" name="quot_unitprice" id="quot_unitprice" value="0"/></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                    <td style="width: 50px;"></td>
                    <td>
                        <table cellpadding="5" border="1" class="ldTable">
                            <tr class="colorRow">
                                <th>Item Qty</th>
                                <th>Unit Price</th>
                                <th>Total Value</th>
                            </tr>
                            <tr>
                                <td><input type="text" id="item_qty" name="item_qty" value="0" onkeypress="handleItemQty(event)"/></td>
                                <td><input type="text" id="item_rate" name="item_rate" value="0.00" onkeypress="handleItemUPrice(event)"/></td>
                                <td><input type="text" id="item_total_value" name="item_total_value" value="0.00" onkeypress="handleItemTotal(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><input type="text" id="tfvalue1" name="tfvalue1" value="0.00" onkeypress="handleTFV1(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><input type="text" id="tfvalue2" name="tfvalue2" value="0.00" onkeypress="handleTFV2(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><input type="text" id="tfvalue3" name="tfvalue3" value="0.00" onkeypress="handleTFV3(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><input type="text" id="tfvalue4" name="tfvalue4" value="0.00" onkeypress="handleTFV4(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><input type="text" id="tfvalue5" name="tfvalue5" value="0.00" onkeypress="handleTFV5(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td><input type="text" id="tfvalue6" name="tfvalue6" value="0.00" onkeypress="handleTFV6(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>Total</td>
                                <td><input type="text" id="totalR" name="totalR" value="0.00" onkeypress="handleTotalR(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>NBT</td>
                                <td><input type="text" id="nbt" name="nbt" value="0.00" onkeypress="handleNBT(event)"/></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td>VAT</td>
                                <td><input type="text" id="vat" name="vat" value="0.00" onkeypress="handleVAT(event)" /></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td class="bdFont">Total Value</td>
                                <td><input type="text" id="realTotalValue" name="realTotalValue" value="0.00" /></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>PROFIT / LOSS :</td>
                                <td><input type="text" id="profitORloss" name="profitORloss" value="" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>G. P MARGIN :</td>
                                <td><input type="text" id="gpmargin" name="gpmargin" value="" />%</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>PAYMENT TERM :</td>
                                <td><input type="text" id="payment_duration" name="payment_duration" value="" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td><input type="submit" value="Proceed Final Output" onclick="calculateRealCost()" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                                <td>
                                    <?php
                                    echo form_open("Quotation_Controller/saveItemCostDetails");
                                    ?>
                                    <input hidden="" type="text" name="ic_customer" id="ic_customer" value="" />
                                    <input hidden="" type="text" name="ic_item_name" id="ic_item_name" value="" />
                                    <input hidden="" type="text" name="ic_costed_price" id="ic_costed_price" value="" />
                                    <input hidden="" type="text" name="ic_quoted_price" id="ic_quoted_price" value="" />
                                    <input hidden="" type="text" name="ic_item_length" id="ic_item_length" value="" />
                                    <input hidden="" type="text" name="ic_item_width" id="ic_item_width" value="" />
                                    <input hidden="" type="text" name="ic_item_material" id="ic_item_material" value="" />
                                    <input hidden="" type="text" name="ic_item_qty" id="ic_item_qty" value="" />
                                    <input hidden="" type="text" name="ic_item_rqty" id="ic_item_rqty" value="" />
                                    <input hidden="" type="text" name="ic_item_outs" id="ic_item_outs" value="" />
                                    <input type="submit" value="Save Costing"/>
                                    <?php
                                    echo form_close();
                                    ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
    </center>
</body>
<script type="text/javascript">

    function handleItemQty(e) {
        if (e.keyCode === 13) {
            $("#item_rate").focus();
        }
        return false;
    }
    function handleItemUPrice(e) {
        if (e.keyCode === 13) {
            $("#item_total_value").focus();
            calculateRealCost();
        }
        return false;
    }
    function handleItemTotal(e) {
        if (e.keyCode === 13) {
            $("#tfvalue1").focus();
            calculateRealCost();
        }
        return false;
    }
    function handleTFV1(e) {
        if (e.keyCode === 13) {
            $("#tfvalue2").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleTFV2(e) {
        if (e.keyCode === 13) {
            $("#tfvalue3").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleTFV3(e) {
        if (e.keyCode === 13) {
            $("#tfvalue4").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleTFV4(e) {
        if (e.keyCode === 13) {
            $("#tfvalue5").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleTFV5(e) {
        if (e.keyCode === 13) {
            $("#tfvalue6").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleTFV6(e) {
        if (e.keyCode === 13) {
            $("#totalR").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleTotalR(e) {
        if (e.keyCode === 13) {
            $("#nbt").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleNBT(e) {
        if (e.keyCode === 13) {
            $("#vat").focus();
            calculateRealCost();
        }
        return false;
    }

    function handleVAT(e) {
        if (e.keyCode === 13) {
            $("#realTotalValue").focus();
            calculateRealCost();
        }
        return false;
    }
</script>
</html>
